define([
    'backbone',
    'modules/appointments/booked/cancellation-confirm-popup-view',
], function(Backbone, CancellationConfirmPopupView) {
    'use strict';

    describe('Cancellation Confirm Popup View with Cancel Reasons', function() {
        var view;
        var $view;

        beforeEach(function() {
            var cancelReasonsMock;
            var modelMock;

            spyOn(CancellationConfirmPopupView.prototype, 'getRegion').and.callThrough();

            cancelReasonsMock = [
                {
                    'id': '6',
                    'number': '6',
                    'text': 'DEATH IN FAMILY',
                    'value': '6',
                },
                {
                    'id': '11',
                    'number': '11',
                    'text': 'OTHER',
                    'value': '11',
                },
                {
                    'id': '12',
                    'number': '12',
                    'text': 'TRANSFER OPT CARE TO OTHER VA',
                    'value': '12',
                },
                {
                    'id': '4',
                    'number': '4',
                    'text': 'TRAVEL DIFFICULTY',
                    'value': '4',
                },
                {
                    'id': '5',
                    'number': '5',
                    'text': 'UNABLE TO KEEP APPOINTMENT',
                    'value': '5',
                },
                {
                    'id': '1',
                    'number': '1',
                    'text': 'WEATHER',
                    'value': '1',
                },
            ];

            modelMock = {
                id: 'cancelReason',
            };
            view = new CancellationConfirmPopupView({
                model: new Backbone.Model(modelMock),
                validator: 'foobar',
                cancelReasonList: new Backbone.Collection(cancelReasonsMock),
            });

            $('body').append('<a class="element-for-focus" href="#"></a>');

            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            // view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('.ui-header h2').text()).toEqual('Cancel Appointment');
        });

        it('has a label to warn fields that are required', function() {
            var expectedText = '* required field';
            expect($view.find('.ui-content p:first-of-type').text()).toEqual(expectedText);
        });

        it('has a cancelReason form in the content', function() {
            expect($view.find('form').length).toEqual(1);

            expect($view.find('form').hasClass('cancel-reason-section')).toBe(true);
        });

        it('has Confirm Cancellation and Close without Cancelling popup buttons', function() {
            expect($view.find('.popup-footer-buttons div').length).toEqual(1);

            expect($view.find('button, a[role=button]').length).toEqual(2);

            expect($view.find('#cancel-appointment-btn').text()).toEqual('Confirm Cancellation');

            expect($view.find('#cancel-return-btn').text()).toEqual('Close without Cancelling');
        });
    });
});
